# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate
    
    # Check for deterministic opponent strategies
    opponent_code_lower = opponent_program_code.lower()
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    # Late-game exploitation (last 2 rounds)
    if len(opp_history) >= 8:
        # Check if opponent has forgiven defections in the past
        forgiveness_count = 0
        for i in range(1, len(my_history)):
            if my_history[i] == "D" and opp_history[i] == "C":
                forgiveness_count += 1
        forgiveness_rate = forgiveness_count / len(my_history) if len(my_history) > 0 else 0
        if forgiveness_rate > 0.2:  # If opponent is forgiving, defect in last rounds
            return "D"
    
    # Adaptive Tit-for-Tat with controlled aggression
    last_opp_move = opp_history[-1]
    if last_opp_move == "C":
        # Cooperate with 90% probability, defect with 10%
        if random.random() < 0.9:
            return "C"
        else:
            return "D"
    else:  # opponent defected
        # Retaliate with 80% probability, forgive with 20%
        if random.random() < 0.8:
            return "D"
        else:
            return "C"